# Commerce modeling of stock and capacity

## Initial state
One Series with 4 Series Passes, each with a different capacity setting.

-- Series Pass (own capacity of 1200)
post_id	meta_key	meta_value
4	_tec_tickets_commerce_event	3
4	_tribe_ticket_show_description	yes
4	_price	23
4	_type	series_pass
4	_manage_stock	yes
4	_stock	1200
4	_tribe_ticket_capacity	1200
4	_tribe_ticket_version	5.6.0-dev
4	_sku	4-1-5-DAYS-OF-CONCERT
4	_global_stock_mode	own
4	_stock_status	instock
4	_backorders	no
4	_tribe_tickets_ar_iac	none
4	_tribe_tickets_meta	a:0:{}
4	_ticket_start_date	2023-05-03 00:00:00

-- Series Pass (unlimited capacity)
post_id	meta_key	meta_value
5	_tec_tickets_commerce_event	3
5	_tribe_ticket_show_description	yes
5	_price	123
5	_type	series_pass
5	_manage_stock	no
5	_tribe_ticket_capacity	-1
5	_tribe_ticket_version	5.6.0-dev
5	_sku	5-1-UNLIMITED-CAP-PASS
5	_tribe_tickets_ar_iac	none
5	_tribe_tickets_meta	a:0:{}
5	_ticket_start_date	2023-05-03 00:00:00

-- Series Pass (global capacity)
post_id	meta_key	meta_value
6	_tec_tickets_commerce_event	3
6	_tribe_ticket_show_description	yes
6	_price	234
6	_type	series_pass
6	_manage_stock	yes
6	_stock	2389
6	_tribe_ticket_capacity	2389
6	_tribe_ticket_version	5.6.0-dev
6	_sku	6-1-GLOBAL-CAP-PASS
6	_global_stock_mode	global
6	_stock_status	instock
6	_backorders	no
6	_tribe_tickets_ar_iac	none
6	_tribe_tickets_meta	a:0:{}
6	_ticket_start_date	2023-05-03 00:00:00

-- Series Pass (capped capacity of 25)
post_id	meta_key	meta_value
7	_tec_tickets_commerce_event	3
7	_tribe_ticket_show_description	yes
7	_price	34
7	_type	series_pass
7	_manage_stock	yes
7	_stock	25
7	_tribe_ticket_capacity	25
7	_tribe_ticket_version	5.6.0-dev
7	_sku	7-1-CAPPED-CAP-PASS
7	_global_stock_mode	capped
7	_stock_status	instock
7	_backorders	no
7	_tribe_tickets_ar_iac	none
7	_tribe_tickets_meta	a:0:{}
7	_ticket_start_date	2023-05-03 00:00:00

-- Series (before any purchase)
post_id	meta_key	meta_value
3	_tribe_hide_attendees_list
3	_tribe_default_ticket_provider	TEC\Tickets\Commerce\Module
3	_tec-series-show-title	1
3	_tec_autogenerated_checksum	afa7e0397e3be4e71a231d5c775e4eac
3	_tec_autogenerated	1
3	_edit_lock	1683118421:1
3	_tribe_ticket_capacity	2389
3	_tribe_ticket_version	5.6.0-dev
3	_tribe_ticket_use_global_stock	1
3	_tribe_ticket_global_stock_level	2389
3	_EventCost	23
3	_EventCost	123
3	_EventCost	234
3	_EventCost	34

### Observations
1. Tickets are related to the Series by means of the `_tec_tickets_commerce_event` meta key; this should be redirected to the `posts_and_posts` table, the type is `ticket_and_post_series_pass`.
2. A Series with global capacity has the `_tribe_ticket_capacity` meta key set to the max value of the global capacity; this should be redirected to the Series capacity in the `capacities` table and `max_value` column, related to the Series by means of the `capacities_relationships` table.
3. The `_tribe_ticket_use_global_stock` Series meta is a boolean value (either `0` or `1`) that should be redirected to the `capacities_relationships` table: `0` if there is no relationship for the Series, `1` otherwise.
4. The `_tribe_ticket_global_stock_level` Series meta holds the current value of the global capacity; this should be redirected to the Series `capacities` table and `current_value` column, related to the Series by means of the `capacities_relationships` table.
5. The Ticket '_manage_stock' meta is a boolean (`no` or `yes`) value that should be redirected to the `capacities` table, `mode` column: if `mode = unlimited` the value is `no`, otherwise the value is `yes`.
6. The Ticket `_stock` meta should be redirected to the `capacities` table, `current_value` column, related to the Ticket by means of the `capacities_relationships` table.
7. The Ticket `_tribe_ticket_capacity` meta should be redirected to the `capacities` table, `max_value` column, related to the Ticket by means of the `capacities_relationships` table.
8. The Ticket `_global_stock_mode` meta should be redirected to the `capacities` table, `mode` column: if `mode = global` the value is `global`, if `mode = capped` the value is `capped`, otherwise the value should be an empty string.
9. The ticket `_stock_status` meta should be redirected to the `capacities` table using the `current_value` and `max_value` columns: if `current_value <= 0`  return `outofstock`, else return `instock`.

### Questions
a. What meta key is used by WooCommerce Tickets?
b. What meta key is used by EDD Tickets?
c. Is the `_managing_stock` meta key used by both WooCommerce and EDD Tickets? How?
d. What level of dependency on the meta is there embedded in the code? After initial meta redirection is set up, there should be more elements.

## State after purchase of 2 Global Capacity passes, ID 6

-- Series
post_id	meta_key	meta_value
3	_tribe_hide_attendees_list
3	_tribe_default_ticket_provider	TEC\Tickets\Commerce\Module
3	_tec-series-show-title	1
3	_tec_autogenerated_checksum	afa7e0397e3be4e71a231d5c775e4eac
3	_tec_autogenerated	1
3	_edit_lock	1683118421:1
3	_tribe_ticket_capacity	2389
3	_tribe_ticket_version	5.6.0-dev
3	_tribe_ticket_use_global_stock	1
3	_tribe_ticket_global_stock_level	2387
3	_EventCost	23
3	_EventCost	123
3	_EventCost	234
3	_EventCost	34

-- Series Pass (global capacity)
post_id	meta_key	meta_value
6	_tec_tickets_commerce_event	3
6	_tribe_ticket_show_description	yes
6	_price	234
6	_type	series_pass
6	_manage_stock	yes
6	_stock	2387
6	_tribe_ticket_capacity	2389
6	_tribe_ticket_version	5.6.0-dev
6	_sku	6-1-GLOBAL-CAP-PASS
6	_global_stock_mode	global
6	_stock_status	instock
6	_backorders	no
6	_tribe_tickets_ar_iac	none
6	_tribe_tickets_meta	a:0:{}
6	_ticket_start_date	2023-05-03 00:00:00
6	_tec_tc_ticket_status_count:created	0
6	_tec_tc_ticket_status_count:pending	0
6	_tec_tc_ticket_status_count:completed	2
6	total_sales	2

-- Series Pass (capped capacity of 25)
post_id	meta_key	meta_value
7	_tec_tickets_commerce_event	3
7	_tribe_ticket_show_description	yes
7	_price	34
7	_type	series_pass
7	_manage_stock	yes
7	_stock	25
7	_tribe_ticket_capacity	25
7	_tribe_ticket_version	5.6.0-dev
7	_sku	7-1-CAPPED-CAP-PASS
7	_global_stock_mode	capped
7	_stock_status	instock
7	_backorders	no
7	_tribe_tickets_ar_iac	none
7	_tribe_tickets_meta	a:0:{}
7	_ticket_start_date	2023-05-03 00:00:00

### Observations
1. The observations done before about stock and capacity hold true.

## State after purchase of 2 Capped Capacity passes, ID 7

-- Series
post_id	meta_key	meta_value
3	_tribe_hide_attendees_list
3	_tribe_default_ticket_provider	TEC\Tickets\Commerce\Module
3	_tec-series-show-title	1
3	_tec_autogenerated_checksum	afa7e0397e3be4e71a231d5c775e4eac
3	_tec_autogenerated	1
3	_edit_lock	1683118421:1
3	_tribe_ticket_capacity	2389
3	_tribe_ticket_version	5.6.0-dev
3	_tribe_ticket_use_global_stock	1
3	_tribe_ticket_global_stock_level	2385
3	_EventCost	23
3	_EventCost	123
3	_EventCost	234
3	_EventCost	34

-- Series Pass (global capacity)
post_id	meta_key	meta_value
6	_tec_tickets_commerce_event	3
6	_tribe_ticket_show_description	yes
6	_price	234
6	_type	series_pass
6	_manage_stock	yes
6	_stock	2387
6	_tribe_ticket_capacity	2389
6	_tribe_ticket_version	5.6.0-dev
6	_sku	6-1-GLOBAL-CAP-PASS
6	_global_stock_mode	global
6	_stock_status	instock
6	_backorders	no
6	_tribe_tickets_ar_iac	none
6	_tribe_tickets_meta	a:0:{}
6	_ticket_start_date	2023-05-03 00:00:00
6	_tec_tc_ticket_status_count:created	0
6	_tec_tc_ticket_status_count:pending	0
6	_tec_tc_ticket_status_count:completed	2
6	total_sales	2

-- Series Pass (capped capacity of 25)
post_id	meta_key	meta_value
7	_tec_tickets_commerce_event	3
7	_tribe_ticket_show_description	yes
7	_price	34
7	_type	series_pass
7	_manage_stock	yes
7	_stock	23
7	_tribe_ticket_capacity	25
7	_tribe_ticket_version	5.6.0-dev
7	_sku	7-1-CAPPED-CAP-PASS
7	_global_stock_mode	capped
7	_stock_status	instock
7	_backorders	no
7	_tribe_tickets_ar_iac	none
7	_tribe_tickets_meta	a:0:{}
7	_ticket_start_date	2023-05-03 00:00:00
7	_tec_tc_ticket_status_count:created	0
7	_tec_tc_ticket_status_count:pending	0
7	_tec_tc_ticket_status_count:completed	2
7	total_sales	2

## State after updating Capped Capacity Pass to 89

-- Series Pass (capped capacity of 25)
post_id	meta_key	meta_value
7	_tec_tickets_commerce_event	3
7	_tribe_ticket_show_description	yes
7	_price	34
7	_type	series_pass
7	_manage_stock	yes
7	_stock	87
7	_tribe_ticket_capacity	89
7	_tribe_ticket_version	5.6.0-dev
7	_sku	7-1-CAPPED-CAP-PASS
7	_global_stock_mode	capped
7	_stock_status	instock
7	_backorders	no
7	_tribe_tickets_ar_iac	none
7	_tribe_tickets_meta	a:0:{}
7	_ticket_start_date	2023-05-03
7	_tec_tc_ticket_status_count:created	0
7	_tec_tc_ticket_status_count:pending	0
7	_tec_tc_ticket_status_count:completed	2
7	total_sales	2
7	_tribe_ticket_manual_updated	_ticket_start_date

### Observations
1. Both `_tribe_ticket_capacity` and `_stock` are updated by `(89 - 25) = 64`.
